/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.CdDvd;
import com.ibm.hwmca.fw.mediasvc.DiscoverDevices;
import com.ibm.hwmca.fw.mediasvc.Diskette;
import com.ibm.hwmca.fw.mediasvc.HdPartition;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesErrorIds;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameterKeys;
import com.ibm.hwmca.fw.mediasvc.MediaServicesParameters;
import com.ibm.hwmca.fw.mediasvc.MediaServicesResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MediaServices
implements MediaServicesErrorIds,
MediaServicesParameterKeys {
    private static final String TRACE_MASKT = "XMDASRVT";
    private static final String TRACE_MASKF = "XMDASRVF";
    private static final String TRACE_MASKD = "XMDASRVD";
    private static MediaServices mediaServices;
    public static final int MEDIA_DISKETTE = 1;
    public static final int MEDIA_CDROM = 2;
    public static final int MEDIA_DVDRAM = 3;
    public static final int MEDIA_HDPARTITION = 4;
    public static final int MEDIA_WRITABLE_MASS = 6;
    public static final int MEDIA_READONLY_MASS = 7;
    static final String DEVICE_DISKETTE = "DD";
    static final String DEVICE_CDROM = "CD";
    static final String DEVICE_DVDRAM = "DV";
    static final String DEVICE_HDPARTITION = "HD";
    private HashMap mediaDeviceIdentifiers;
    private MediaServicesParameters mediaServicesParameters;

    private MediaServices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.MediaServices()");
        this.mediaServicesParameters = MediaServicesParameters.getMediaServicesParameters();
        try {
            File logFile;
            File tempDir = new File(this.mediaServicesParameters.getParm("media.temp.dir"));
            if (tempDir.exists() && !tempDir.isDirectory() && tempDir.delete()) {
                if (tempDir.mkdir()) {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Created new Media Services temp directory " + tempDir.toString());
                } else {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Failed to create new Media Services temp directory " + tempDir.toString());
                }
            }
            if (!tempDir.exists()) {
                if (tempDir.mkdir()) {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Created new Media Services temp directory " + tempDir.toString());
                } else {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Failed to create new Media Services temp directory " + tempDir.toString());
                }
            }
            if ((logFile = new File(this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log"))).exists()) {
                if (logFile.delete()) {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Deleted old Media Services log file " + logFile.toString());
                } else {
                    Trace.trace(TRACE_MASKF, "MediaServices.MediaServices(): Failed to delete old Media Services log file " + logFile.toString());
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 608, mdexc).log();
            throw mdexc;
        }
        this.mediaDeviceIdentifiers = new DiscoverDevices().getHashMapOfDevices();
        if (this.mediaDeviceIdentifiers == null) {
            MediaDeviceException mdexc = new MediaDeviceException("no devices returned");
            Trace.trace(TRACE_MASKF, mdexc);
            new FrameworkLog(MediaServicesErrorIds._logInfo, 609, mdexc).log();
            throw mdexc;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.MediaServices()");
    }

    public static synchronized MediaServices getMediaServices() throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getMediaServices()");
        if (mediaServices == null) {
            mediaServices = new MediaServices();
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getMediaServices()");
        return mediaServices;
    }

    public LocalizableText getMediaDisplayableName(int mediaType) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getMediaDisplayableName(mediaType = " + mediaType + ")");
        LocalizableText displayableName = null;
        switch (mediaType) {
            case 1: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.diskette.name"));
                break;
            }
            case 2: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.cd.name"));
                break;
            }
            case 3: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.dvdram.name"));
                break;
            }
            case 4: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.hd.name"));
                break;
            }
            case 6: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.mass.w.name"));
                break;
            }
            case 7: {
                displayableName = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.mass.r.name"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or Unsupported Media Type Specified.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getMediaDisplayableName(): returns " + displayableName);
        return displayableName;
    }

    public LocalizableText getMediaDisplayableTitle(int mediaType) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getMediaDisplayableTitle(mediaType = " + mediaType + ")");
        LocalizableText displayableTitle = null;
        switch (mediaType) {
            case 1: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.diskette.title"));
                break;
            }
            case 2: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.cd.title"));
                break;
            }
            case 3: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.dvdram.title"));
                break;
            }
            case 4: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.hd.title"));
                break;
            }
            case 6: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.mass.w.title"));
                break;
            }
            case 7: {
                displayableTitle = new LocalizableText(MediaServicesResourceBundle.getString("com/ibm/hwmca/fw/mediasvc/res/mediares", Locale.getDefault(), "media.mass.r.title"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or Unsupported Media Type Specified.");
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getMediaDisplayableTitle(): returns " + displayableTitle.toString());
        return displayableTitle;
    }

    public MediaDeviceIdentifier getPreferredDevice(int mediaType) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getPreferredDevice(mediaType = " + mediaType + ")");
        if (mediaType < 1 || mediaType > 7) {
            throw new IllegalArgumentException("invalid media type specified");
        }
        Set deviceIdSet = this.mediaDeviceIdentifiers.entrySet();
        Iterator iterator = deviceIdSet.iterator();
        MediaDeviceIdentifier preferredDeviceId = null;
        while (iterator.hasNext()) {
            Map.Entry me = iterator.next();
            MediaDeviceIdentifier deviceId = (MediaDeviceIdentifier)me.getValue();
            if (!deviceId.isPreferred() || !deviceId.isMediaSupported(mediaType)) continue;
            Trace.trace(TRACE_MASKF, "MediaServices.getPreferredDevice(): found preferred device");
            preferredDeviceId = deviceId;
            break;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getPreferredDevice()");
        return preferredDeviceId;
    }

    public MediaDeviceIdentifier[] getMediaDeviceIdentifiers() {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getMediaDeviceIdentifiers()");
        ArrayList al = new ArrayList();
        Set deviceSet = this.mediaDeviceIdentifiers.entrySet();
        Iterator iterator = deviceSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry me = iterator.next();
            al.add(me.getValue());
        }
        Object[] ia = al.toArray();
        MediaDeviceIdentifier[] ma = new MediaDeviceIdentifier[ia.length];
        int k = 0;
        while (k < ia.length) {
            ma[k] = (MediaDeviceIdentifier)ia[k];
            ++k;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getMediaDeviceIdentifiers()");
        return ma;
    }

    public MediaDeviceIdentifier[] getMediaDeviceIdentifiers(int mediaType) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.getMediaDeviceIdentifiers(mediaType = " + mediaType + ")");
        if (mediaType < 1 || mediaType > 7) {
            throw new IllegalArgumentException("invalid media type specified");
        }
        MediaDeviceIdentifier[] ma = this.getMediaDeviceIdentifiers();
        int supporters = 0;
        int i = 0;
        while (i < ma.length) {
            if (ma[i].isMediaSupported(mediaType)) {
                ++supporters;
            }
            ++i;
        }
        if (supporters == 0) {
            return null;
        }
        MediaDeviceIdentifier[] sma = new MediaDeviceIdentifier[supporters];
        int k = 0;
        int i2 = 0;
        while (i2 < ma.length) {
            if (ma[i2].isMediaSupported(mediaType)) {
                sma[k++] = ma[i2];
            }
            ++i2;
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.getMediaDeviceIdentifiers()");
        return sma;
    }

    public MediaDeviceIdentifier queryMediaDevicePath(String filePath) {
        MediaDeviceIdentifier mediaDeviceIdentifier;
        block12: {
            Trace.trace(TRACE_MASKT, "-> MediaServices.queryMediaDevicePath(" + filePath + ")");
            mediaDeviceIdentifier = null;
            if (filePath != null) {
                MediaDeviceIdentifier[] mediaDeviceIds = this.getMediaDeviceIdentifiers();
                int i = 0;
                while (i < mediaDeviceIds.length) {
                    String mountPoint = mediaDeviceIds[i].getMediaDeviceProperties().getMountPoint();
                    Trace.trace(TRACE_MASKD, "MediaServices.queryMediaDevicePath(): The mount point for the media device = " + mountPoint);
                    if (mountPoint != null && mountPoint.length() > 0 && filePath.startsWith(mountPoint)) {
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): The media device with the mount point, " + mountPoint + " was found for the file path, " + filePath);
                        mediaDeviceIdentifier = mediaDeviceIds[i];
                        break;
                    }
                    ++i;
                }
                if (mediaDeviceIdentifier == null) {
                    Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): No media device was found for the given file path,  " + filePath);
                    Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): Checking to see if the file path begins with a symbolic link to a media device mount point.");
                    try {
                        if (!filePath.matches("/.*/.*/.*")) break block12;
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): The file path matches the regular expression.");
                        int index = 0;
                        int tempIndex = 0;
                        int i2 = 0;
                        while (i2 < 3) {
                            index = filePath.indexOf("/", tempIndex);
                            if (index == -1) break;
                            tempIndex = index + 1;
                            ++i2;
                        }
                        if (index == -1) break block12;
                        String symPath = filePath.substring(0, index);
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): symPath = " + symPath);
                        String tempFile = this.mediaServicesParameters.getParm("media.temp.dir") + "symlink.out";
                        String[] scriptCmd = new String[]{"findsymlink.sh", symPath, tempFile, this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): scriptCmd[0] = " + scriptCmd[0]);
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): scriptCmd[1] = " + scriptCmd[1]);
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): scriptCmd[2] = " + scriptCmd[2]);
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): scriptCmd[3] = " + scriptCmd[3]);
                        int rc = RootProcess.executeProgram(scriptCmd);
                        Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): rc = " + rc);
                        if (rc != 0) break block12;
                        String buffer = null;
                        FileReader tfr = new FileReader(tempFile);
                        BufferedReader tbr = new BufferedReader(tfr);
                        buffer = tbr.readLine();
                        if (buffer != null) {
                            Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): The temp file " + tempFile + " was NOT empty.");
                            StringTokenizer st = new StringTokenizer(buffer);
                            int numTokens = st.countTokens();
                            int i3 = 0;
                            while (i3 < numTokens) {
                                String token = st.nextToken();
                                Trace.trace(TRACE_MASKD, "token = " + token);
                                if (token.equals("->")) break;
                                ++i3;
                            }
                            filePath = st.nextToken();
                            Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): filePath = " + filePath);
                        } else {
                            Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): The temp file, " + tempFile + " was empty.");
                        }
                        tfr.close();
                        mediaDeviceIds = this.getMediaDeviceIdentifiers();
                        int j = 0;
                        while (j < mediaDeviceIds.length) {
                            String mountPoint = mediaDeviceIds[j].getMediaDeviceProperties().getMountPoint();
                            Trace.trace(TRACE_MASKD, "MediaServices.queryMediaDevicePath(): The mount point for the media device = " + mountPoint);
                            if (mountPoint != null && mountPoint.length() > 0 && (filePath.startsWith(mountPoint) || filePath.equals(mountPoint))) {
                                Trace.trace(TRACE_MASKF, "MediaServices.queryMediaDevicePath(): The media device with the mount point, " + mountPoint + " was found for the file path, " + filePath);
                                mediaDeviceIdentifier = mediaDeviceIds[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (Exception exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.queryMediaDevicePath()");
        return mediaDeviceIdentifier;
    }

    public synchronized MediaDevice requestLock(LocalizableText callerName, MediaDeviceIdentifier deviceID) throws MediaDeviceException, MediaDeviceLockException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.requestLock(callerName = " + callerName.toString() + ", " + "deviceID= " + deviceID + ")");
        MediaDevice mediaDevice = null;
        String strCallerName = callerName.toString();
        if (strCallerName == null) {
            throw new IllegalArgumentException("cannot use a caller name of null");
        }
        boolean blankCallerName = true;
        int i = 0;
        while (i < strCallerName.length()) {
            if (strCallerName.charAt(i) != ' ') {
                blankCallerName = false;
                break;
            }
            ++i;
        }
        if (blankCallerName) {
            throw new IllegalArgumentException("cannot use a blank caller name");
        }
        Trace.trace(TRACE_MASKF, "MediaServices.requestLock(): callerName = " + strCallerName);
        deviceID.notifyListenersOfLockRequest();
        if (deviceID.isLocked()) {
            throw new MediaDeviceLockException("The device is currently locked by " + deviceID.getCurrentLockOwner().toString(), deviceID.getCurrentLockOwner());
        }
        deviceID.lock();
        deviceID.setCurrentLockOwner(callerName);
        Trace.trace(TRACE_MASKF, "MediaServices.requestLock(): The Media Device identifier " + deviceID.getInternalDeviceName() + " is now locked by " + deviceID.getCurrentLockOwner() + ". " + "Returning the appropriate MediaDevice object to the lock owner, " + deviceID.getCurrentLockOwner() + ".");
        if (deviceID.getDeviceType().equals(DEVICE_DISKETTE)) {
            mediaDevice = new Diskette(deviceID);
        }
        if (deviceID.getDeviceType().equals(DEVICE_CDROM)) {
            mediaDevice = new CdDvd(deviceID);
        }
        if (deviceID.getDeviceType().equals(DEVICE_DVDRAM)) {
            mediaDevice = new CdDvd(deviceID);
        }
        if (deviceID.getDeviceType().equals(DEVICE_HDPARTITION)) {
            mediaDevice = new HdPartition(deviceID);
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.requestLock()");
        return mediaDevice;
    }

    public synchronized MediaDevice requestLock(LocalizableText callerName, MediaDeviceIdentifier deviceID, int timeout) throws MediaDeviceException, MediaDeviceLockException, InterruptedException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> MediaServices.requestLock(callerName = " + callerName + ", " + "deviceID = " + deviceID + ")");
        MediaDevice mediaDevice = null;
        boolean noLock = true;
        if (timeout <= 0) {
            mediaDevice = this.requestLock(callerName, deviceID);
            noLock = false;
        } else {
            int i = 0;
            while (i <= timeout) {
                try {
                    mediaDevice = this.requestLock(callerName, deviceID);
                    noLock = false;
                    break;
                }
                catch (MediaDeviceLockException exc) {
                    Thread.sleep(1000L);
                    ++i;
                }
            }
        }
        if (noLock) {
            throw new MediaDeviceLockException("The device is currently locked by " + deviceID.getCurrentLockOwner().toString() + "." + "Couldn't obtain lock in timeout period.", deviceID.getCurrentLockOwner());
        }
        Trace.trace(TRACE_MASKT, "<- MediaServices.requestLock()");
        return mediaDevice;
    }
}

